# Freigabe

Ein ausgearbeiteter Vertrag kann zur Prüfung in den Umlauf gegeben werden. Der Vertrag durchläuft hier einen Freigabeprozess, welcher mit dessen <span
style='font-weight:bold;font-style:italic'>Freigabe</span> oder <span
style='font-weight:bold;font-style:italic'>Ablehnung</span> endet.

{@img img1.png}

Die Vertragsfreigabe kann zu jeder Phase eingeleitet werden. Dies ermöglicht Freigabeszenarien vor und nach der <a
href="#!/guide/pFA843D33_178F_4995_9EF9_6807252DC76E">Vertragsverhandlung</a>. Während der Vertragsfreigabe können alle Beteiligten Korrekturen an den Vertragsdokumenten bzw. am Vertrag vornehmen.

Während der Freigabe erhält der Vertrag den Status &quot;In Freigabe&quot;. Freigegebene Verträge werden mithilfe des Status &quot;Freigegeben&quot; gekennzeichnet, abgelehnte Verträge werden in den Status &quot;Entwurf&quot; eingestuft.

> <span
style='font-style:italic'>Ein Vertragsmanager erstellt einen Entwurf eines Rahmenvertrags und gibt diesen in den Freigabeprozess. Als Prüfschritte wurden in der Konfiguration die Rechtsabteilung, Buchhaltung sowie die Geschäftsführung identifiziert. Nach Abschluss des Freigabeprozesses, oder falls ein Benutzer die Freigabe ablehnt, bekommt der Vertragsmanager eine Benachrichtigung als Aufgabe.</span>

{@img img3.png}

## Prüfungsschritte

Schritte innerhalb der Vertragsfreigabe werden als Prüfungsschritte bezeichnet. Im Kern sind Prüfungsschritte definiert durch alle Benutzer und Gruppen, die im Prozess beteiligt sind. Die Liste der Prüfungsschritte kann zur Laufzeit bearbeitet werden. Dies erlaubt es, weitere Schritte einzufügen oder Schritte zu entfernen, wenn diese bspw. nicht mehr notwendig sind.

Dürfen Schritte von den Folgebenutzern nicht bearbeitet werden, kann dies über die Option &quot;verpflichtend&quot; gesteuert werden.

{@img img5.png}

Im Prozess wird die Liste über einen Zyklus von oben abgearbeitet. Wird der Workflow einem Anwender zur Freigabe zugestellt, wird dieser (erster Benutzer der Liste) aus der Liste entfernt. Dies führt zur nachfolgenden Abarbeitung der Prozessschritte.

Die Prüfschritte der Vertragsfreigabe können über die Rollen-Konfiguration gesteuert werden. Diese findet sich in der Konfiguration des Vertragsmanagements in der Einstellung <span
style='font-weight:bold;font-style:italic'>Dynamische Benutzerrollen</span>. Die Rolle für die Vertragsfreigabe ist <span
style='font-weight:bold;font-style:italic'>APPROVAL</span>.

{@img img7.png}

## Berechtigungserweiterung im Freigabeprozess

Teilnehmenden Benutzern werden je nach Konfiguration im Workflow Rechte eingeräumt, so dass diese Verträge sehen oder bearbeiten dürfen. Weitere Informationen zur Berechtigungserweiterung gibt das Kapitel <a
href="#!/guide/p89F88CAF_C876_4A5C_8F86_B7348320FF1C">Berechtigungen</a>.

## Aktion: Freigabe einleiten

Die Aktion kann im Reiter `Verträge` der Multifunktionsleiste aufgerufen werden. 

{@img img9.png}

### Vorbedingungen

*   Ein Vertrag ist ausgewählt.

### Dateneingabe: Freigabe einleiten

Für die Dateneingabe wird die Formular-Tab-Gruppe `003_1_initiate_approval` eingesetzt. 

{@img img11.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Freigabe</span></td></tr></thead><tbody><tr><td>610_initiate_approval</td></tr><tr><td>100_users</td></tr></tbody></table>


### Dateneingabe: Prüfung der Vertragsdaten

Für die Dateneingabe wird die Formular-Tab-Gruppe `003_2_approve_contract` eingesetzt. 

{@img img13.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Freigabe</span></td><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>611_contract_approval</td><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td>100_users</td><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td></td><td>230_contract_data</td><td></td><td></td><td></td></tr><tr><td></td><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td></td><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>


### Dateneingabe: Abschluss des Freigabeprozesses

Für die Dateneingabe wird die Formular-Tab-Gruppe `003_3_finish_approval` eingesetzt. 

{@img img15.png}

Diese setzt sich aus folgenden Bausteinen zusammen:

<table><thead><tr><td><span
style='font-weight:bold'>Freigabe</span></td><td><span
style='font-weight:bold'>Vertragsdaten</span></td><td><span
style='font-weight:bold'>Laufzeit</span></td><td><span
style='font-weight:bold'>Vertragspartner</span></td><td><span
style='font-weight:bold'>Zahlungsplan</span></td></tr></thead><tbody><tr><td>612_finish_approval</td><td>210_general</td><td>310_duration</td><td>510_partner</td><td>410_payment</td></tr><tr><td></td><td>220_company</td><td></td><td>520_partner_address</td><td></td></tr><tr><td></td><td>230_contract_data</td><td></td><td></td><td></td></tr><tr><td></td><td>240_accounting</td><td></td><td></td><td></td></tr><tr><td></td><td>250_project</td><td></td><td></td><td></td></tr></tbody></table>

### Implementierung

<span class="tag_warning"><span
style='font-weight:bold'>Action definitions:</span> Definitionen der Aktion für die Clients finden sich in der Konfiguration `sol.contract.InitiateApproval`.</span>

Der <span
style='font-weight:bold'>technische Ablauf</span> wird durch die Index Server Aktion `sol.contract.ix.actions.ApproveContract` implementiert. Diese startet den Workflow `sol.contract.contract.approval`.

Im Erfolgsfall werden folgende Events an den Client übermittelt:

<table><thead><tr><td>Event</td><td>Beschreibung</td><td>Status</td></tr></thead><tbody><tr><td>DIALOG</td><td>Zeigt das Formular zur Dateneingabe in einem Dialog an.</td><td></td></tr><tr><td>REFRESH</td><td>Aktualisiert die Darstellung des SORD-Objekts.</td><td></td></tr></tbody></table>

<span
style='font-weight:bold'>Beschreibung des Workflows</span>

{@img img17.png}

<table><thead><tr><td><span
style='font-weight:bold'>Knotenbezeichnung</span></td><td><span
style='font-weight:bold'>Knotenname deutsch und Beschreibung</span></td><td><span
style='font-weight:bold'>Funktion</span></td></tr></thead><tbody><tr><td><span
style='font-weight:bold'>USERROLESTOMAP</span></td><td><span
style='font-weight:bold'>USERROLESTOMAP</span><br />Verteilungsknoten: Speichert die für den Freigabeprozess vorgegebenen Benutzerrollen in eine Map Table</td><td>sol.common.ix.functions.UserRolesToMap</td></tr><tr><td><span
style='font-weight:bold'>Set approver</span></td><td><span
style='font-weight:bold'>Prüfer festlegen</span><br />Benutzerknoten: Auswahl eines oder mehrerer Prüfer für die Freigabe</td><td></td></tr><tr><td><span
style='font-weight:bold'>CHANGECOLOR: Approval initiated</span></td><td><span
style='font-weight:bold'>CHANGECOLOR: Freigabe eingeleitet</span><br />Verteilungsknoten: Setzt die Farbe des SORD Objekts</td><td>sol.common.ix.functions.ChangeColor</td></tr><tr><td><span
style='font-weight:bold'>Dynamic flow has approval steps?</span></td><td><span
style='font-weight:bold'>Check ad-hoc flow start</span><br />Entscheidungsknoten: Prüft das Feld ELO_WF_STATUS auf den Wert `CYCLE_START`, um in diesem Fall einen Freigabe-Zyklus zu starten</td><td>sol.common.ix.functions.CheckDynAdHocFlowStart</td></tr><tr><td><span
style='font-weight:bold'>STATUS: Approved</span></td><td><span
style='font-weight:bold'>STATUS: Freigegeben</span><br />Verteilungsknoten: Setzt das Indexfeld CONTRACT_STATUS auf `A`</td><td>sol.common.ix.functions.Status</td></tr><tr><td><span
style='font-weight:bold'>FEED: Immediate approval</span></td><td><span
style='font-weight:bold'>FEED: Sofortige Freigabe</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Freigabe ohne weitere Prüfungen an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>STATUS: Approval</span></td><td><span
style='font-weight:bold'>STATUS: Freigabe</span><br />Verteilungsknoten: Setzt das Indexfeld CONTRACT_STATUS auf `I`</td><td>sol.common.ix.functions.Status</td></tr><tr><td><span
style='font-weight:bold'>FEED: Approval initiated</span></td><td><span
style='font-weight:bold'>FEED: Freigabe eingeleitet</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Einleitung der Freigabe an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>CHANGEUSER: Approval</span></td><td><span
style='font-weight:bold'>CHANGEUSER: Freigabe</span><br />Verteilungsknoten: Ändert den Eigentümer des nächsten Benutzerknotens</td><td>sol.common.ix.functions.ChangeUser</td></tr><tr><td><span
style='font-weight:bold'>Approval</span></td><td><span
style='font-weight:bold'>Freigabe</span><br />Benutzerknoten: Genehmigung durch einen vorgegebenen Prüfer</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Approval accepted</span></td><td><span
style='font-weight:bold'>FEED: Freigabe anerkannt</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Freigabe an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>FEED: Approval rejected</span></td><td><span
style='font-weight:bold'>FEED: Freigabe abgelehnt</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Ablehnung an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>Check rejected</span></td><td><span
style='font-weight:bold'>Check rejected</span><br />Entscheidungsknoten: Prüft das Feld ELO_WF_STATUS auf den Wert `REJECTED`, um den Freigabeprozess entsprechend abzuschließen</td><td></td></tr><tr><td><span
style='font-weight:bold'>Contract approved</span></td><td><span
style='font-weight:bold'>Vertrag genehmigt</span><br />Benutzerknoten: Zur Kenntnisnahme der Anerkennung</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Approval completed</span></td><td><span
style='font-weight:bold'>FEED: Freigabeprozess abgeschlossen</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zum Abschluss des Freigabeprozesses an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>STATUS: Draft</span></td><td><span
style='font-weight:bold'>STATUS: Freigabe</span><br />Verteilungsknoten: Setzt das Indexfeld CONTRACT_STATUS auf `D`</td><td>sol.common.ix.functions.Status</td></tr><tr><td><span
style='font-weight:bold'>Contract rejected</span></td><td><span
style='font-weight:bold'>Vertrag abgelehnt</span><br />Benutzerknoten: Zur Kenntnisnahme der Ablehnung</td><td></td></tr><tr><td><span
style='font-weight:bold'>FEED: Approval declined</span></td><td><span
style='font-weight:bold'>FEED: Freigabe abgewiesen</span><br />Verteilungsknoten: Legt einen Feed-Eintrag zur Abweisung der Freigabe an</td><td>sol.common.ix.functions.FeedComment</td></tr><tr><td><span
style='font-weight:bold'>SET: Delete comment</span></td><td><span
style='font-weight:bold'>SET</span><br />Entfernt das Kommentar des Vorgängers aus der WF_MAP</td><td>sol.common.ix.function.Set</td></tr></tbody></table>





